# Guide d'Installation - WooCommerce Quotes for Woodmart

## 📦 Installation du Plugin

### Méthode 1 : Installation manuelle (Recommandée)

1. **Téléchargez le plugin**
   - Récupérez le dossier complet `wc-quotes-woodmart`

2. **Uploadez sur votre serveur**
   ```
   - Connectez-vous à votre serveur via FTP ou cPanel
   - Naviguez vers : /wp-content/plugins/
   - Uploadez le dossier `wc-quotes-woodmart`
   ```

3. **Activez le plugin**
   ```
   - Connectez-vous à votre administration WordPress
   - Allez dans : Extensions → Extensions installées
   - Trouvez "WooCommerce Quotes for Woodmart"
   - Cliquez sur "Activer"
   ```

### Méthode 2 : Installation via ZIP

1. **Créez une archive ZIP**
   ```bash
   cd /chemin/vers/wc-quotes-woodmart
   zip -r wc-quotes-woodmart.zip .
   ```

2. **Uploadez via WordPress**
   ```
   - Administration WordPress → Extensions → Ajouter
   - Cliquez sur "Téléverser une extension"
   - Choisissez le fichier wc-quotes-woodmart.zip
   - Cliquez sur "Installer maintenant"
   - Activez le plugin
   ```

## ✅ Vérifications après installation

### 1. Vérifier que WooCommerce est actif
```
Administration → Extensions
→ WooCommerce doit être activé
```

### 2. Vérifier les permaliens
```
Administration → Réglages → Permaliens
→ Cliquez sur "Enregistrer les modifications" (même sans modifier)
```

### 3. Vérifier le menu WooCommerce
```
Administration → WooCommerce → Devis
→ Le menu doit être visible
```

### 4. Tester le bouton sur le panier
```
Frontend → Ajoutez un produit au panier
→ Le bouton "Transformer en devis" doit apparaître
```

### 5. Vérifier l'espace client
```
Frontend → Mon compte
→ L'onglet "Mes devis" doit être présent
```

## 🔧 Configuration Post-Installation

### Permissions recommandées (optionnel)

Si vous souhaitez donner l'accès à la gestion des devis à d'autres rôles :

```php
// Ajoutez ce code dans functions.php de votre thème enfant
add_action('admin_init', function() {
    // Donner l'accès aux Shop Managers
    $role = get_role('shop_manager');
    if ($role) {
        $role->add_cap('edit_shop_quotes');
        $role->add_cap('read_shop_quotes');
        $role->add_cap('delete_shop_quotes');
    }
});
```

### Personnalisation des numéros de devis

```php
// Modifier le préfixe des devis (DEV- par défaut)
add_filter('wcq_quote_number_prefix', function($prefix) {
    return 'DEVIS-'; // Ou ce que vous voulez
});
```

### Durée de validité par défaut

```php
// Modifier la durée de validité par défaut (30 jours)
add_filter('wcq_default_valid_days', function($days) {
    return 60; // 60 jours
});
```

## 🎨 Compatibilité avec Woodmart

Le plugin est conçu pour s'intégrer parfaitement avec Woodmart, mais voici quelques vérifications :

### 1. Cache du thème
```
Woodmart → Paramètres → Performance
→ Videz le cache après l'installation
```

### 2. Styles personnalisés (si nécessaire)
Si vous souhaitez personnaliser les couleurs pour correspondre exactement à votre thème :

```css
/* Ajoutez dans Apparence → Personnaliser → CSS additionnel */
.wcq-create-quote-button {
    background-color: votre-couleur !important;
    color: #fff !important;
}

.wcq-status-pending {
    background: votre-couleur !important;
}
```

## 🐛 Résolution des problèmes courants

### Problème : Le bouton ne s'affiche pas sur le panier

**Solutions :**
1. Vérifiez que WooCommerce est actif
2. Videz tous les caches (plugin, navigateur, serveur)
3. Vérifiez qu'il y a des produits dans le panier
4. Désactivez temporairement les autres plugins pour tester

### Problème : Erreur 404 sur les pages de devis

**Solution :**
```
Administration → Réglages → Permaliens
→ Cliquez sur "Enregistrer les modifications"
```

### Problème : Les devis ne s'enregistrent pas

**Solutions :**
1. Vérifiez que l'utilisateur est connecté
2. Vérifiez les permissions de la base de données
3. Activez le mode débogage WordPress :
```php
// Dans wp-config.php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```
4. Consultez le fichier debug.log

### Problème : Le PDF ne se génère pas

**Note :** La génération de PDF dans cette version utilise une méthode simple HTML. Pour une génération PDF avancée, installez une bibliothèque comme DomPDF :

```bash
# Via Composer dans le dossier du plugin
composer require dompdf/dompdf
```

### Problème : Conflit avec d'autres plugins

**Solutions :**
1. Désactivez tous les autres plugins
2. Réactivez-les un par un pour identifier le conflit
3. Contactez le support si nécessaire

## 📊 Base de données

Le plugin crée automatiquement :

- **Post type** : `shop_quote`
- **Post statuses** : `quote-pending`, `quote-accepted`, `quote-rejected`, `quote-expired`
- **Meta fields** : `_quote_number`, `_quote_data`, `_quote_total`, etc.

Aucune table personnalisée n'est créée dans cette version, tout utilise les tables WordPress standards.

## 🔒 Sécurité

Le plugin est sécurisé avec :
- ✅ Vérification des nonces
- ✅ Vérification des permissions
- ✅ Échappement des données
- ✅ Validation des entrées
- ✅ Protection CSRF

## 📱 Test Mobile

Après installation, testez sur mobile :
1. Ajoutez un produit au panier
2. Vérifiez que le bouton est responsive
3. Créez un devis
4. Consultez dans "Mon compte"

## 🚀 Mise en production

Avant de mettre en production :

1. ✅ Testez sur un environnement de staging
2. ✅ Vérifiez tous les workflows (création, consultation, conversion)
3. ✅ Testez avec différents rôles utilisateur
4. ✅ Testez sur mobile et desktop
5. ✅ Vérifiez les e-mails
6. ✅ Testez la génération de PDF
7. ✅ Faites une sauvegarde complète

## 📞 Support

Si vous rencontrez des problèmes :

1. Consultez ce guide
2. Vérifiez le fichier README.md
3. Activez le mode débogage WordPress
4. Consultez les logs d'erreur
5. Contactez le développeur avec :
   - Version de WordPress
   - Version de WooCommerce
   - Version du thème Woodmart
   - Message d'erreur complet
   - Étapes pour reproduire le problème

## 🎉 Félicitations !

Votre plugin est maintenant installé et prêt à l'emploi !

Pour toute question, référez-vous à la documentation complète dans le fichier README.md.
