# WooCommerce Quotes for Woodmart

**Version:** 1.3.0  
**Auteur:** Yann VALLET  
**Compatibilité:** WordPress 6.0+, WooCommerce 8.0+, Woodmart 7.0+

---

## 📖 Description

Plugin WooCommerce permettant aux clients de créer des devis directement depuis leur panier. Interface 100% style Woodmart pour une expérience utilisateur cohérente.

---

## ✨ Fonctionnalités

### Pour les Clients

✅ **Créer des devis** depuis le panier
✅ **Modifier les quantités** avec boutons +/-
✅ **Supprimer des articles** du devis
✅ **Télécharger en PDF**
✅ **Recevoir par email**
✅ **Commander** directement depuis le devis

### Pour les Admins

✅ **Gérer tous les devis** dans WooCommerce
✅ **Accepter/Refuser** les devis
✅ **Convertir en commande** en 1 clic
✅ **Suivi complet** des statuts

---

## 🎨 Interface Woodmart

La v1.3.0 adopte **complètement** le style Woodmart :
- Design identique au checkout
- Boutons +/- comme dans le panier
- Bouton de suppression circulaire
- Structure HTML Woodmart native

---

## 🚀 Installation

1. Téléversez le plugin via WordPress Admin
2. Activez le plugin
3. Allez dans **Réglages → Permaliens → Enregistrer**
4. Videz tous les caches
5. Testez avec un devis !

**Guide complet :** [INSTALLATION-RAPIDE-V1.3.0.md](../INSTALLATION-RAPIDE-V1.3.0.md)

---

## 📝 Utilisation

### Créer un Devis (Client)

1. Ajoutez des produits au panier
2. Sur la page panier, cliquez **"Créer un devis"**
3. Le devis est créé et accessible dans **Mon Compte → Mes Devis**

### Modifier un Devis (Client)

1. Ouvrez un devis **"EN ATTENTE"**
2. Utilisez **[-]** / **[+]** pour changer les quantités
3. Cliquez **⊗** pour supprimer un article
4. Cliquez **[METTRE À JOUR LE DEVIS]**

### Gérer les Devis (Admin)

1. **WooCommerce → Devis**
2. Cliquez sur un devis pour voir les détails
3. **Accepter / Refuser / Convertir en commande**

---

## 🔧 Configuration

### Bouton "Créer un Devis"

Par défaut, le bouton apparaît sur la page panier après le bouton "Commander".

**Personnaliser :**
```php
// Dans functions.php du thème enfant
add_filter('wcq_cart_button_position', function() {
    return 'before_checkout'; // ou 'after_checkout'
});
```

### Durée de Validité

Par défaut : 30 jours

**Modifier :**
```php
add_filter('wcq_default_validity_days', function() {
    return 60; // 60 jours au lieu de 30
});
```

---

## 🎨 Personnalisation CSS

```css
/* Couleur du bouton "Mettre à jour" */
.wcq-update-quote-btn {
    background: #0073aa !important;
}

/* Masquer le bouton de suppression */
.wd-checkout-remove-btn-wrapp {
    display: none !important;
}
```

---

## 📚 Documentation

- **[VERSION-1.3.0-WOODMART-STYLE.md](../VERSION-1.3.0-WOODMART-STYLE.md)** - Guide complet
- **[AVANT-APRES-V1.3.0.md](../AVANT-APRES-V1.3.0.md)** - Comparaison visuelle
- **[INSTALLATION-RAPIDE-V1.3.0.md](../INSTALLATION-RAPIDE-V1.3.0.md)** - Guide d'installation

---

## 🐛 Support

En cas de problème :

1. Videz TOUS les caches (Woodmart, plugins, navigateur)
2. Rechargez en navigation privée (Ctrl+Shift+N)
3. Vérifiez la console JavaScript (F12)
4. Consultez la section **Dépannage** du guide complet

---

## 📋 Changelog

### v1.3.0 (30/10/2024)
✨ Refonte complète de l'interface style Woodmart
✨ Boutons +/- pour les quantités
✨ Bouton de suppression circulaire
🐛 Correction comparaison statuts
🐛 Amélioration du formatage des prix

### v1.2.1 (30/10/2024)
🐛 Correction des comparaisons de statut
🐛 Amélioration du formatage des prix JavaScript

### v1.2.0 (30/10/2024)
✨ Édition des quantités
✨ Suppression d'articles
✨ Mise à jour en temps réel

### v1.1.2 (29/10/2024)
✨ Variations et attributs dans les devis
✨ Conversion en commande
✨ Téléchargement PDF

### v1.0.0 (28/10/2024)
🎉 Version initiale

---

## 📄 Licence

Ce plugin est fourni tel quel, sans garantie d'aucune sorte.

---

## ⭐ Crédits

Développé par **Yann VALLET**  
Thème : **Woodmart** by XTemos Studio  
Framework : **WordPress** & **WooCommerce**

---

**Merci d'utiliser WooCommerce Quotes for Woodmart !** 🎉
