/**
 * WooCommerce Quotes for Woodmart - Admin Scripts
 */

(function($) {
    'use strict';
    
    var WCQ_Admin = {
        
        /**
         * Initialisation
         */
        init: function() {
            this.bindEvents();
        },
        
        /**
         * Lier les événements
         */
        bindEvents: function() {
            $(document).on('click', '.wcq-convert-quote', this.convertQuote);
            $(document).on('click', '.wcq-email-quote', this.emailQuote);
        },
        
        /**
         * Convertir un devis en commande
         */
        convertQuote: function(e) {
            e.preventDefault();
            
            if (!confirm(wcq_admin_params.i18n.confirm_convert || 'Êtes-vous sûr de vouloir convertir ce devis en commande ?')) {
                return;
            }
            
            var $button = $(this);
            var quoteId = $button.data('quote-id');
            
            $button.prop('disabled', true).addClass('wcq-loading').text('Conversion...');
            
            $.ajax({
                url: wcq_admin_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'wcq_convert_to_order',
                    nonce: wcq_admin_params.nonce,
                    quote_id: quoteId
                },
                success: function(response) {
                    if (response.success) {
                        WCQ_Admin.showNotice(response.data.message, 'success');
                        
                        // Rediriger vers la commande créée
                        if (response.data.redirect) {
                            setTimeout(function() {
                                window.location.href = response.data.redirect;
                            }, 1500);
                        } else {
                            // Recharger la page
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);
                        }
                    } else {
                        WCQ_Admin.showNotice(response.data.message || 'Erreur inconnue', 'error');
                        $button.prop('disabled', false).removeClass('wcq-loading').text('Convertir en commande');
                    }
                },
                error: function() {
                    WCQ_Admin.showNotice('Erreur lors de la conversion du devis', 'error');
                    $button.prop('disabled', false).removeClass('wcq-loading').text('Convertir en commande');
                }
            });
        },
        
        /**
         * Envoyer le devis par e-mail
         */
        emailQuote: function(e) {
            e.preventDefault();
            
            var $button = $(this);
            var quoteId = $button.data('quote-id');
            
            var email = prompt('Entrez l\'adresse e-mail du destinataire :');
            
            if (!email) {
                return;
            }
            
            $button.prop('disabled', true).addClass('wcq-loading');
            
            $.ajax({
                url: wcq_admin_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'wcq_send_quote_email',
                    nonce: wcq_admin_params.nonce,
                    quote_id: quoteId,
                    email: email
                },
                success: function(response) {
                    if (response.success) {
                        WCQ_Admin.showNotice(response.data.message, 'success');
                    } else {
                        WCQ_Admin.showNotice(response.data.message || 'Erreur inconnue', 'error');
                    }
                    $button.prop('disabled', false).removeClass('wcq-loading');
                },
                error: function() {
                    WCQ_Admin.showNotice('Erreur lors de l\'envoi de l\'e-mail', 'error');
                    $button.prop('disabled', false).removeClass('wcq-loading');
                }
            });
        },
        
        /**
         * Afficher une notification
         */
        showNotice: function(message, type) {
            type = type || 'info';
            
            var noticeClass = type === 'success' ? 'notice-success' : 'notice-error';
            
            var $notice = $('<div class="notice ' + noticeClass + ' is-dismissible wcq-admin-notice wcq-admin-notice-' + type + '"><p>' + message + '</p></div>');
            
            $('.wrap h1').first().after($notice);
            
            // Supprimer automatiquement après 5 secondes
            setTimeout(function() {
                $notice.fadeOut(function() {
                    $(this).remove();
                });
            }, 5000);
        }
    };
    
    // Initialiser au chargement du document
    $(document).ready(function() {
        WCQ_Admin.init();
    });
    
})(jQuery);
