<?php
/**
 * Gestion des types de posts personnalisés
 *
 * @package WC_Quotes_Woodmart
 */

if (!defined('ABSPATH')) {
    exit;
}

class WCQ_Post_Types {
    
    /**
     * Constructeur
     */
    public function __construct() {
        add_action('init', array($this, 'register_post_types'));
        add_action('init', array($this, 'register_post_status'));
    }
    
    /**
     * Enregistrer les types de posts personnalisés
     */
    public function register_post_types() {
        // Enregistrer le post type pour les devis
        $labels = array(
            'name'               => __('Devis', 'wc-quotes-woodmart'),
            'singular_name'      => __('Devis', 'wc-quotes-woodmart'),
            'menu_name'          => __('Devis', 'wc-quotes-woodmart'),
            'add_new'            => __('Ajouter un devis', 'wc-quotes-woodmart'),
            'add_new_item'       => __('Ajouter un nouveau devis', 'wc-quotes-woodmart'),
            'edit_item'          => __('Modifier le devis', 'wc-quotes-woodmart'),
            'new_item'           => __('Nouveau devis', 'wc-quotes-woodmart'),
            'view_item'          => __('Voir le devis', 'wc-quotes-woodmart'),
            'search_items'       => __('Rechercher des devis', 'wc-quotes-woodmart'),
            'not_found'          => __('Aucun devis trouvé', 'wc-quotes-woodmart'),
            'not_found_in_trash' => __('Aucun devis dans la corbeille', 'wc-quotes-woodmart'),
        );
        
        $args = array(
            'labels'              => $labels,
            'public'              => false,
            'show_ui'             => true,
            'show_in_menu'        => false, // On va l'ajouter manuellement dans WooCommerce
            'capability_type'     => 'shop_order',
            'map_meta_cap'        => true,
            'hierarchical'        => false,
            'supports'            => array('title'),
            'has_archive'         => false,
            'rewrite'             => false,
            'query_var'           => false,
            'show_in_rest'        => false,
        );
        
        register_post_type('shop_quote', $args);
    }
    
    /**
     * Enregistrer les statuts de devis personnalisés
     */
    public function register_post_status() {
        register_post_status('quote-pending', array(
            'label'                     => _x('En attente', 'Quote status', 'wc-quotes-woodmart'),
            'public'                    => false,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop('En attente <span class="count">(%s)</span>', 'En attente <span class="count">(%s)</span>', 'wc-quotes-woodmart'),
        ));
        
        register_post_status('quote-accepted', array(
            'label'                     => _x('Accepté', 'Quote status', 'wc-quotes-woodmart'),
            'public'                    => false,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop('Accepté <span class="count">(%s)</span>', 'Acceptés <span class="count">(%s)</span>', 'wc-quotes-woodmart'),
        ));
        
        register_post_status('quote-replaced', array(
            'label'                     => _x('Remplacé', 'Quote status', 'wc-quotes-woodmart'),
            'public'                    => false,
            'exclude_from_search'       => true,
            'show_in_admin_all_list'    => false,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop('Remplacé <span class="count">(%s)</span>', 'Remplacés <span class="count">(%s)</span>', 'wc-quotes-woodmart'),
        ));
        
        register_post_status('quote-rejected', array(
            'label'                     => _x('Refusé', 'Quote status', 'wc-quotes-woodmart'),
            'public'                    => false,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop('Refusé <span class="count">(%s)</span>', 'Refusés <span class="count">(%s)</span>', 'wc-quotes-woodmart'),
        ));
        
        register_post_status('quote-expired', array(
            'label'                     => _x('Expiré', 'Quote status', 'wc-quotes-woodmart'),
            'public'                    => false,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop('Expiré <span class="count">(%s)</span>', 'Expirés <span class="count">(%s)</span>', 'wc-quotes-woodmart'),
        ));

        register_post_status('quote-transferred', array(
            'label'                     => _x('Transféré', 'Quote status', 'wc-quotes-woodmart'),
            'public'                    => false,
            'exclude_from_search'       => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop('Transféré <span class="count">(%s)</span>', 'Transférés <span class="count">(%s)</span>', 'wc-quotes-woodmart'),
        ));
    }
}

new WCQ_Post_Types();
