<?php
/**
 * Template pour afficher un devis individuel (lecture seule + bouton modifier)
 *
 * @package WC_Quotes_Woodmart
 */

if (!defined('ABSPATH')) {
    exit;
}

$quote_id = get_query_var('quotes', 0);

// Si pas d'ID ou liste demandée
if (empty($quote_id) || $quote_id === 'list') {
    wc_get_template('myaccount/quotes-list.php', array(), '', WCQ_PLUGIN_DIR . 'templates/');
    return;
}

// Récupérer le devis
$quote = get_post($quote_id);

if (!$quote || $quote->post_type !== 'shop_quote') {
    echo '<p>' . __('Devis introuvable.', 'wc-quotes-woodmart') . '</p>';
    return;
}

// Vérifier que c'est le bon client
$customer_id = get_post_meta($quote_id, '_customer_id', true);
if ($customer_id != get_current_user_id()) {
    echo '<p>' . __('Vous n\'avez pas accès à ce devis.', 'wc-quotes-woodmart') . '</p>';
    return;
}

// Récupérer les données
$quote_number = get_post_meta($quote_id, '_quote_number', true);
$quote_data = get_post_meta($quote_id, '_quote_data', true);
$quote_total = get_post_meta($quote_id, '_quote_total', true);
$valid_until = get_post_meta($quote_id, '_valid_until', true);
$created_at = get_the_date('', $quote);

// Récupérer les informations de transfert
$transferred_from = get_post_meta($quote_id, '_transferred_from', true);
$transfer_from_name = get_post_meta($quote_id, '_transfer_from_name', true);
$transfer_to_name = get_post_meta($quote_id, '_transfer_to_name', true);
$transferred_to = get_post_meta($quote_id, '_transferred_to', true);
$is_transferred_quote = get_post_meta($quote_id, '_is_transferred_quote', true);

// Déterminer le statut
$status = $quote->post_status;
$status_labels = array(
    'quote-pending' => __('En attente', 'wc-quotes-woodmart'),
    'quote-accepted' => __('Accepté', 'wc-quotes-woodmart'),
    'quote-rejected' => __('Refusé', 'wc-quotes-woodmart'),
    'quote-expired' => __('Expiré', 'wc-quotes-woodmart'),
    'quote-replaced' => __('Remplacé', 'wc-quotes-woodmart'),
    'quote-transferred' => __('Transféré', 'wc-quotes-woodmart'),
);
$status_label = isset($status_labels[$status]) ? $status_labels[$status] : $status;

?>

<div class="woocommerce-MyAccount-content">
    <p>
        <a href="<?php echo esc_url(wc_get_account_endpoint_url('quotes')); ?>" class="woocommerce-Button button">
            <?php _e('← Retour à mes devis', 'wc-quotes-woodmart'); ?>
        </a>
    </p>
    
    <h2><?php echo sprintf(__('Devis %s', 'wc-quotes-woodmart'), esc_html($quote_number)); ?></h2>
    
    <table class="woocommerce-table woocommerce-table--order-details shop_table order_details">
        <tbody>
            <tr>
                <th><?php _e('Date d\'émission', 'wc-quotes-woodmart'); ?></th>
                <td><?php echo esc_html($created_at); ?></td>
            </tr>
            <tr>
                <th><?php _e('Statut', 'wc-quotes-woodmart'); ?></th>
                <td>
                    <mark class="quote-status status-<?php echo esc_attr($status); ?>">
                        <?php
                        // Afficher "Transféré par" si le devis a été transféré
                        if ($status === 'quote-transferred') {
                            $transferred_by_id = get_post_meta($quote_id, '_transferred_by', true);
                            $transfer_to_name = get_post_meta($quote_id, '_transfer_to_name', true);

                            if ($transferred_by_id) {
                                $transferred_by_user = get_userdata($transferred_by_id);
                                if ($transferred_by_user) {
                                    echo __('Transféré par : ', 'wc-quotes-woodmart') . '<strong>' . esc_html($transferred_by_user->display_name) . '</strong>';
                                    if ($transfer_to_name) {
                                        echo '<br><small style="color: #666;">' . __('à ', 'wc-quotes-woodmart') . esc_html($transfer_to_name) . '</small>';
                                    }
                                } else {
                                    echo esc_html($status_label);
                                }
                            } else {
                                echo esc_html($status_label);
                            }
                        } else {
                            echo esc_html($status_label);
                        }
                        ?>
                    </mark>
                </td>
            </tr>
            <?php if ($valid_until) : ?>
            <tr>
                <th><?php _e('Valide jusqu\'au', 'wc-quotes-woodmart'); ?></th>
                <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($valid_until))); ?></td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if ($is_transferred_quote && $transferred_from && $transfer_from_name) : ?>
    <div class="woocommerce-message" style="margin-top: 20px; margin-bottom: 20px; padding: 15px; background: #e7f7ff; border-left: 4px solid #2ea2cc;">
        <h3 style="margin-top: 0;"><?php _e('Informations de transfert', 'wc-quotes-woodmart'); ?></h3>
        <p>
            <strong><?php _e('Ce devis vous a été transféré par :', 'wc-quotes-woodmart'); ?></strong><br>
            <?php echo esc_html($transfer_from_name); ?>
        </p>
        <?php if ($transfer_to_name) : ?>
        <p>
            <strong><?php _e('Destinataire :', 'wc-quotes-woodmart'); ?></strong><br>
            <?php echo esc_html($transfer_to_name); ?>
        </p>
        <?php endif; ?>
    </div>
    <?php elseif ($transferred_to && $transfer_to_name) : ?>
    <div class="woocommerce-info" style="margin-top: 20px; margin-bottom: 20px; padding: 15px; background: #fff8e5; border-left: 4px solid #ffba00;">
        <h3 style="margin-top: 0;"><?php _e('Informations de transfert', 'wc-quotes-woodmart'); ?></h3>
        <p>
            <strong><?php _e('Vous avez transféré ce devis à :', 'wc-quotes-woodmart'); ?></strong><br>
            <?php echo esc_html($transfer_to_name); ?>
        </p>
        <?php if ($transfer_from_name) : ?>
        <p>
            <strong><?php _e('Expéditeur :', 'wc-quotes-woodmart'); ?></strong><br>
            <?php echo esc_html($transfer_from_name); ?>
        </p>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <?php if (current_user_can('manage_woocommerce')) : ?>
    <div class="wcq-admin-actions" style="margin: 20px 0; padding: 20px; background: #f0f8ff; border-left: 4px solid #2271b1; border-radius: 4px;">
        <h3 style="margin-top: 0; color: #2271b1;">🔧 Actions administrateur</h3>
        <form method="post" action="" id="wcq-transfer-form">
            <?php wp_nonce_field('wcq_admin_transfer_quote', 'wcq_transfer_nonce'); ?>
            <input type="hidden" name="wcq_action" value="admin_transfer">
            <input type="hidden" name="quote_id" value="<?php echo esc_attr($quote_id); ?>">

            <p>
                <label for="wcq-customer-select" style="display: block; margin-bottom: 8px; font-weight: 600;">
                    <?php _e('Transférer ce devis à un autre client :', 'wc-quotes-woodmart'); ?>
                </label>
                <select name="new_customer_id" id="wcq-customer-select" style="width: 100%; max-width: 500px;" required>
                    <option value="">-- <?php _e('Sélectionner un client', 'wc-quotes-woodmart'); ?> --</option>
                    <?php
                    $customers = get_users(array(
                        'role__in' => array('customer', 'administrator', 'shop_manager'),
                        'orderby' => 'display_name',
                        'order' => 'ASC',
                        'number' => -1,
                    ));
                    foreach ($customers as $customer) {
                        if ($customer->ID != $customer_id) {
                            echo '<option value="' . esc_attr($customer->ID) . '">';
                            echo esc_html($customer->display_name) . ' (' . esc_html($customer->user_email) . ')';
                            echo '</option>';
                        }
                    }
                    ?>
                </select>
            </p>

            <p>
                <button type="submit" class="button alt" style="margin-right: 10px;">
                    <?php _e('Transférer le devis', 'wc-quotes-woodmart'); ?>
                </button>
                <span class="description" style="color: #666;">
                    <?php _e('Le client actuel gardera le devis original avec le statut "Transféré".', 'wc-quotes-woodmart'); ?>
                </span>
            </p>
        </form>
    </div>

    <script type="text/javascript">
    jQuery(document).ready(function($) {
        // Vérifier si Select2 est disponible (fourni par WooCommerce)
        if ($.fn.select2) {
            $('#wcq-customer-select').select2({
                placeholder: '-- <?php _e('Sélectionner un client', 'wc-quotes-woodmart'); ?> --',
                allowClear: true,
                width: '100%',
                language: {
                    noResults: function() {
                        return '<?php _e('Aucun client trouvé', 'wc-quotes-woodmart'); ?>';
                    },
                    searching: function() {
                        return '<?php _e('Recherche en cours...', 'wc-quotes-woodmart'); ?>';
                    }
                }
            });
        }

        // Confirmation avant transfert
        $('#wcq-transfer-form').on('submit', function(e) {
            var selectedCustomer = $('#wcq-customer-select option:selected').text();
            if (selectedCustomer && !confirm('<?php _e('Êtes-vous sûr de vouloir transférer ce devis à', 'wc-quotes-woodmart'); ?> ' + selectedCustomer + ' ?')) {
                e.preventDefault();
                return false;
            }
        });
    });
    </script>
    <?php endif; ?>

    <h3><?php _e('Produits', 'wc-quotes-woodmart'); ?></h3>
    
    <table class="woocommerce-table woocommerce-table--order-details shop_table order_details wcq-quote-table">
        <thead>
            <tr>
                <th class="product-thumbnail"><?php _e('Image', 'wc-quotes-woodmart'); ?></th>
                <th class="product-name"><?php _e('Produit', 'wc-quotes-woodmart'); ?></th>
                <th class="product-quantity"><?php _e('Quantité', 'wc-quotes-woodmart'); ?></th>
                <th class="product-total"><?php _e('Total', 'wc-quotes-woodmart'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($quote_data as $item) :
                $product_id = isset($item['variation_id']) && $item['variation_id'] > 0 ? $item['variation_id'] : $item['product_id'];
                $product = wc_get_product($product_id);

                if (!$product) continue;
            ?>
            <?php
            // Calculer la remise
            $line_subtotal = isset($item['line_subtotal']) ? floatval($item['line_subtotal']) : floatval($item['line_total']);
            $line_total = floatval($item['line_total']);
            $has_discount = ($line_subtotal > $line_total && $line_subtotal > 0);
            ?>
            <tr>
                <td class="product-thumbnail">
                    <?php echo $product->get_image('thumbnail'); ?>
                </td>
                <td class="product-name">
                    <?php
                    echo wp_kses_post($product->get_name());

                    // Afficher les attributs pour les variations
                    if ($product->is_type('variation') && isset($item['variation'])) {
                        echo '<br><small class="variation">';
                        $variation_attributes = array();
                        foreach ($item['variation'] as $key => $value) {
                            $taxonomy = str_replace('attribute_', '', $key);
                            $term = get_term_by('slug', $value, $taxonomy);
                            $label = wc_attribute_label($taxonomy);
                            $variation_attributes[] = '<strong>' . $label . ':</strong> ' . ($term ? $term->name : $value);
                        }
                        echo implode(', ', $variation_attributes);
                        echo '</small>';
                    }

                    // Afficher les dates de livraison
                    foreach ($item as $key => $value) {
                        // Exclure les clés standards
                        if (in_array($key, array('product_id', 'variation_id', 'variation', 'quantity', 'line_total', 'line_subtotal', 'line_tax', 'line_subtotal_tax', 'data', 'data_hash', 'key'))) {
                            continue;
                        }

                        // Vérifier si c'est une date de livraison
                        $is_delivery = (stripos($key, 'livraison') !== false || stripos($key, 'delivery') !== false);

                        if ($is_delivery && !empty($value)) {
                            echo '<br><small class="variation-Livraisonestime" style="color: #2ea2cc;">';
                            echo '<span class="item-variation-name">Livraison estimée:</span> ';
                            echo '<span class="item-variation-value">';

                            // Si c'est un tableau ou un objet, extraire la valeur
                            if (is_array($value)) {
                                if (isset($value['value'])) {
                                    echo wp_kses_post($value['value']);
                                } elseif (isset($value[0])) {
                                    echo wp_kses_post($value[0]);
                                }
                            } elseif (is_object($value)) {
                                if (isset($value->value)) {
                                    echo wp_kses_post($value->value);
                                }
                            } else {
                                echo wp_kses_post($value);
                            }

                            echo '</span></small>';
                            break;
                        }
                    }
                    ?>
                </td>
                <td class="product-quantity">
                    × <?php echo esc_html($item['quantity']); ?>
                </td>
                <td class="product-total">
                    <?php if ($has_discount) : ?>
                        <del><span class="woocommerce-Price-amount amount"><?php echo wc_price($line_subtotal); ?></span></del>
                        <ins><span class="woocommerce-Price-amount amount"><?php echo wc_price($line_total); ?></span></ins>
                    <?php else : ?>
                        <?php echo wc_price($line_total); ?>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="3"><?php _e('Total', 'wc-quotes-woodmart'); ?></th>
                <td class="product-total-grand"><?php echo wc_price($quote_total); ?></td>
            </tr>
        </tfoot>
    </table>
    
    <?php if ($status === 'quote-pending') : ?>
    <p class="wcq-actions">
        <a href="<?php echo esc_url(add_query_arg(array('wcq_action' => 'convert', 'quote_id' => $quote_id, '_wpnonce' => wp_create_nonce('wcq_convert_' . $quote_id)))); ?>" 
           class="button alt">
            <?php _e('Commander ce devis', 'wc-quotes-woodmart'); ?>
        </a>
        
        <a href="<?php echo esc_url(add_query_arg(array('wcq_action' => 'load_to_cart', 'quote_id' => $quote_id, '_wpnonce' => wp_create_nonce('wcq_load_' . $quote_id)))); ?>" 
           class="button">
            <?php _e('Modifier le devis', 'wc-quotes-woodmart'); ?>
        </a>
        
        <a href="<?php echo esc_url(add_query_arg(array('wcq_action' => 'download_pdf', 'quote_id' => $quote_id))); ?>" 
           class="button" target="_blank">
            <?php _e('Télécharger en PDF', 'wc-quotes-woodmart'); ?>
        </a>
        
        <a href="<?php echo esc_url(add_query_arg(array('wcq_action' => 'send_email', 'quote_id' => $quote_id))); ?>" 
           class="button">
            <?php _e('Recevoir par email', 'wc-quotes-woodmart'); ?>
        </a>
        
        <a href="<?php echo esc_url(add_query_arg(array('wcq_action' => 'delete', 'quote_id' => $quote_id, '_wpnonce' => wp_create_nonce('wcq_delete_' . $quote_id)))); ?>" 
           class="button" 
           onclick="return confirm('<?php esc_attr_e('Êtes-vous sûr de vouloir supprimer ce devis ?', 'wc-quotes-woodmart'); ?>');">
            <?php _e('Supprimer', 'wc-quotes-woodmart'); ?>
        </a>
    </p>
    <?php endif; ?>
</div>

<style>
/* Agrandir la colonne Total pour que le montant soit lisible sur une ligne */
.wcq-quote-table .product-total {
    min-width: 150px;
    white-space: nowrap;
    text-align: right;
    font-weight: bold;
    font-size: 1.1em;
}

.wcq-quote-table .product-total-grand {
    min-width: 150px;
    white-space: nowrap;
    text-align: right;
    font-weight: bold;
    font-size: 1.3em;
    color: #333;
}

/* Style pour les images de produits */
.wcq-quote-table .product-thumbnail {
    width: 80px;
    text-align: center;
}

.wcq-quote-table .product-thumbnail img {
    max-width: 70px;
    height: auto;
    border-radius: 4px;
}
</style>
