<?php
/**
 * Template de la liste des devis dans l'espace client
 *
 * @package WC_Quotes_Woodmart
 * @var array $quotes Liste des devis
 */

if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="wcq-customer-quotes">
    <h2><?php _e('Mes devis', 'wc-quotes-woodmart'); ?></h2>
    
    <?php if (empty($quotes)) : ?>
        <div class="woocommerce-info">
            <?php _e('Vous n\'avez pas encore de devis.', 'wc-quotes-woodmart'); ?>
        </div>
        <p>
            <a href="<?php echo esc_url(wc_get_page_permalink('shop')); ?>" class="button">
                <?php _e('Continuer mes achats', 'wc-quotes-woodmart'); ?>
            </a>
        </p>
    <?php else : ?>
        <table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table">
            <thead>
                <tr>
                    <th class="woocommerce-orders-table__header">
                        <span class="nobr"><?php _e('Devis', 'wc-quotes-woodmart'); ?></span>
                    </th>
                    <th class="woocommerce-orders-table__header">
                        <span class="nobr"><?php _e('Date', 'wc-quotes-woodmart'); ?></span>
                    </th>
                    <th class="woocommerce-orders-table__header">
                        <span class="nobr"><?php _e('Statut', 'wc-quotes-woodmart'); ?></span>
                    </th>
                    <th class="woocommerce-orders-table__header">
                        <span class="nobr"><?php _e('Validité', 'wc-quotes-woodmart'); ?></span>
                    </th>
                    <th class="woocommerce-orders-table__header">
                        <span class="nobr"><?php _e('Total', 'wc-quotes-woodmart'); ?></span>
                    </th>
                    <th class="woocommerce-orders-table__header">
                        <span class="nobr"><?php _e('Actions', 'wc-quotes-woodmart'); ?></span>
                    </th>
                </tr>
            </thead>
            
            <tbody>
                <?php foreach ($quotes as $quote) :
                    $status_class = str_replace('quote-', '', $quote['status']);
                    $is_expired = false;

                    if ($quote['valid_until']) {
                        $valid_date = strtotime($quote['valid_until']);
                        $is_expired = $valid_date < current_time('timestamp');
                    }

                    // Vérifier si le devis a été remplacé par une nouvelle version
                    $replaced_by_id = get_post_meta($quote['id'], '_replaced_by_quote_id', true);
                    $is_replaced = !empty($replaced_by_id);

                    // Vérifier si le devis est non lu
                    $is_read = get_post_meta($quote['id'], '_is_read', true);
                    $is_unread = ($is_read != '1' && $quote['status'] === 'quote-pending');
                ?>
                <tr class="woocommerce-orders-table__row order <?php echo $is_replaced ? 'wcq-quote-replaced' : ''; ?> <?php echo $is_unread ? 'wcq-quote-unread' : ''; ?>">

                    <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Devis', 'wc-quotes-woodmart'); ?>">
                        <a href="<?php echo esc_url(wc_get_account_endpoint_url('quotes') . $quote['id'] . '/'); ?>">
                            #<?php echo esc_html($quote['quote_number']); ?>
                            <?php if ($is_unread) : ?>
                                <span class="wcq-unread-indicator">●</span>
                            <?php endif; ?>
                        </a>
                        <?php if ($is_replaced) : ?>
                            <br><small style="color: #999;">
                                <?php
                                $new_quote_number = get_post_meta($replaced_by_id, '_quote_number', true);
                                printf(__('→ Version actuelle: %s', 'wc-quotes-woodmart'),
                                    '<a href="' . esc_url(wc_get_account_endpoint_url('quotes') . $replaced_by_id . '/') . '">#' . esc_html($new_quote_number) . '</a>');
                                ?>
                            </small>
                        <?php endif; ?>
                    </td>
                    
                    <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Date', 'wc-quotes-woodmart'); ?>">
                        <time datetime="<?php echo esc_attr($quote['created_at']); ?>">
                            <?php echo date_i18n(get_option('date_format'), strtotime($quote['created_at'])); ?>
                        </time>
                    </td>
                    
                    <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Statut', 'wc-quotes-woodmart'); ?>">
                        <span class="wcq-status wcq-status-<?php echo esc_attr($status_class); ?>">
                            <?php
                            $status_labels = array(
                                'quote-pending'  => __('En attente', 'wc-quotes-woodmart'),
                                'quote-accepted' => __('Accepté', 'wc-quotes-woodmart'),
                                'quote-rejected' => __('Refusé', 'wc-quotes-woodmart'),
                                'quote-expired'  => __('Expiré', 'wc-quotes-woodmart'),
                                'quote-replaced' => __('Remplacé', 'wc-quotes-woodmart'),
                                'quote-transferred' => __('Transféré', 'wc-quotes-woodmart'),
                            );

                            // Vérifier si le numéro de devis se termine par "-trans"
                            $is_transferred_quote = substr($quote['quote_number'], -6) === '-trans';

                            // Si le devis a été transféré (statut "quote-transferred")
                            if ($quote['status'] === 'quote-transferred') {
                                $transferred_by_id = get_post_meta($quote['id'], '_transferred_by', true);
                                $transfer_to_name = get_post_meta($quote['id'], '_transfer_to_name', true);

                                if ($transferred_by_id) {
                                    $transferred_by_user = get_userdata($transferred_by_id);
                                    if ($transferred_by_user) {
                                        echo __('Transféré par : ', 'wc-quotes-woodmart') . '<strong>' . esc_html($transferred_by_user->display_name) . '</strong>';
                                        if ($transfer_to_name) {
                                            echo '<br><small style="color: #666;">' . __('à ', 'wc-quotes-woodmart') . esc_html($transfer_to_name) . '</small>';
                                        }
                                    } else {
                                        echo esc_html($status_labels[$quote['status']]);
                                    }
                                } else {
                                    echo esc_html($status_labels[$quote['status']]);
                                }
                            }
                            // Si le numéro de devis se termine par "-trans"
                            elseif ($is_transferred_quote) {
                                $transferred_by_id = get_post_meta($quote['id'], '_transferred_by', true);

                                if ($transferred_by_id) {
                                    $transferred_by_user = get_userdata($transferred_by_id);
                                    if ($transferred_by_user) {
                                        echo esc_html($status_labels[$quote['status']] ?? $quote['status']);
                                        echo '<br><small style="color: #666;">' . __('Transféré par : ', 'wc-quotes-woodmart') . '<strong>' . esc_html($transferred_by_user->display_name) . '</strong></small>';
                                    } else {
                                        echo esc_html($status_labels[$quote['status']] ?? $quote['status']);
                                    }
                                } else {
                                    echo esc_html($status_labels[$quote['status']] ?? $quote['status']);
                                }
                            } else {
                                echo esc_html($status_labels[$quote['status']] ?? $quote['status']);
                            }
                            ?>
                        </span>
                    </td>
                    
                    <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Validité', 'wc-quotes-woodmart'); ?>">
                        <?php if ($quote['valid_until']) : ?>
                            <time datetime="<?php echo esc_attr($quote['valid_until']); ?>" class="<?php echo $is_expired ? 'wcq-expired' : ''; ?>">
                                <?php echo date_i18n(get_option('date_format'), strtotime($quote['valid_until'])); ?>
                            </time>
                            <?php if ($is_expired) : ?>
                                <br><small style="color: red;"><?php _e('Expiré', 'wc-quotes-woodmart'); ?></small>
                            <?php endif; ?>
                        <?php else : ?>
                            —
                        <?php endif; ?>
                    </td>
                    
                    <td class="woocommerce-orders-table__cell" data-title="<?php esc_attr_e('Total', 'wc-quotes-woodmart'); ?>">
                        <?php echo wc_price($quote['total']); ?>
                    </td>
                    
                    <td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-actions" data-title="<?php esc_attr_e('Actions', 'wc-quotes-woodmart'); ?>">
                        <a href="<?php echo esc_url(wc_get_account_endpoint_url('quotes') . $quote['id'] . '/'); ?>" class="woocommerce-button button view">
                            <?php _e('Voir', 'wc-quotes-woodmart'); ?>
                        </a>
                    </td>
                    
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<style>
/* Style pour les devis remplacés - légèrement grisés mais toujours visibles */
.wcq-quote-replaced {
    opacity: 0.7;
    background-color: #f9f9f9;
}

.wcq-quote-replaced:hover {
    opacity: 1;
}

/* Style pour le statut "Remplacé" */
.wcq-status-replaced {
    background-color: #999;
    color: #fff;
    padding: 4px 8px;
    border-radius: 3px;
    font-size: 0.85em;
}

/* Style pour les devis non lus */
.wcq-quote-unread {
    background-color: #fff9e6 !important;
    border-left: 3px solid #f0ad4e;
}

.wcq-quote-unread:hover {
    background-color: #fff5cc !important;
}

.wcq-unread-indicator {
    display: inline-block;
    color: #f0ad4e;
    font-size: 18px;
    line-height: 1;
    vertical-align: middle;
    margin-left: 5px;
    animation: pulse-unread 2s ease-in-out infinite;
}

@keyframes pulse-unread {
    0%, 100% {
        opacity: 1;
    }
    50% {
        opacity: 0.5;
    }
}
</style>
