<?php
/**
 * Désinstallation du plugin
 * 
 * @package WC_Quotes_Woodmart
 */

// Si la désinstallation n'est pas appelée depuis WordPress, on arrête
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Fonction de désinstallation
 */
function wcq_uninstall() {
    global $wpdb;
    
    // Supprimer tous les devis (posts de type shop_quote)
    $quotes = get_posts(array(
        'post_type'      => 'shop_quote',
        'posts_per_page' => -1,
        'post_status'    => 'any',
    ));
    
    foreach ($quotes as $quote) {
        wp_delete_post($quote->ID, true);
    }
    
    // Supprimer les options du plugin
    delete_option('wcq_last_quote_number');
    delete_option('wcq_version');
    delete_option('wcq_settings');
    
    // Supprimer les métadonnées orphelines
    $wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_wcq_%'");
    $wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_quote_%'");
    
    // Supprimer les données utilisateur
    $wpdb->query("DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE 'wcq_%'");
    
    // Note : On ne supprime pas la table personnalisée au cas où l'utilisateur
    // souhaiterait réinstaller le plugin plus tard et conserver ses données.
    // Si vous souhaitez supprimer complètement la table, décommentez la ligne suivante :
    // $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}wc_quotes");
    
    // Vider les règles de réécriture
    flush_rewrite_rules();
}

// Exécuter la désinstallation
wcq_uninstall();
